/**
 *-----------------------------------------------------------------------------------
 *    Filename: ADFInitTermSystem.h
 *-----------------------------------------------------------------------------------
 *-----------------------------------------------------------------------------------
 *    Copyright 2004-2007 Mitsubishi Electric Research Laboratories (MERL)
 *    Initialization and termination utilities used by the Saffron type system
 *    Ronald Perry and Sarah Frisken
 *-----------------------------------------------------------------------------------
 */


/**
 *-----------------------------------------------------------------------------------
 *    To avoid multiple inclusion of header files
 *-----------------------------------------------------------------------------------
 */
#ifndef ADFINITTERMSYSTEM_H
#define ADFINITTERMSYSTEM_H


/**
 *-----------------------------------------------------------------------------------
 *    START: iType Edge Technology
 *-----------------------------------------------------------------------------------
 */
#ifdef FS_EDGE_TECH


/**
 *-----------------------------------------------------------------------------------
 *    Return the application instance (appInst) specified by the application when the
 *    ADF font rendering system was initialized (i.e., when ADFInitSystem() was 
 *    invoked)
 *-----------------------------------------------------------------------------------
 */
ADF_Void *ADFGetAppInst (void *libInst);


/**
 *-----------------------------------------------------------------------------------
 *    To make functions accessible from C++ code
 *-----------------------------------------------------------------------------------
 */
#ifdef __cplusplus
extern "C" {
#endif


/**
 *-----------------------------------------------------------------------------------
 *    End of C++ wrapper
 *-----------------------------------------------------------------------------------
 */
#ifdef __cplusplus
}
#endif


/**
 *-----------------------------------------------------------------------------------
 *    END: iType Edge Technology
 *-----------------------------------------------------------------------------------
 */
#endif

/**
 *-----------------------------------------------------------------------------------
 *    End of ADFINITTERMSYSTEM_H
 *-----------------------------------------------------------------------------------
 */
#endif
